<?php
/**
 * @version     2.0.0
 * @package     com_draughts
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Galaa <contact@galaa.mn> - http://galaa.mn
 */
// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');

// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_draughts/assets/css/draughts.css');

// Version
$xml = simplexml_load_file('components/com_draughts/config.xml');
$type = $xml->xpath('//config/fieldset[@name="draughts"]/field[@name="version"]');
if((string) $type[0]['value'] === 'free'){
?>
<div class="alert">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	<p><strong>This is Free Version!</strong> Full version features:</p>
	<ul>
		<li>Integration between module, plugin and component</li>
		<li>Insert games into articles with editor button</li>
		<li>Show random games with module</li>
		<li>Configurable and powerful module</li>
		<li>Other difference</li>
	</ul>
	<p>Get full version from <a href="http://jextbox.com" target="_blank">JExtBOX - BOX of Joomla Extensions</a>.</p>
</div>
<?php
}
?>

<script type="text/javascript">
	js = jQuery.noConflict();
	js(document).ready(function() {
		
	});
	Joomla.submitbutton = function(task)
	{
		if (task == 'game.cancel') {
			Joomla.submitform(task, document.getElementById('game-form'));
		}
		else {
			if (task != 'game.cancel' && document.formvalidator.isValid(document.id('game-form'))) {
				Joomla.submitform(task, document.getElementById('game-form'));
			}
			else {
				alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
			}
		}
	}
</script>
<form action="<?php echo JRoute::_('index.php?option=com_draughts&layout=edit&id=' . (int) $this->item->id); ?>" method="post" enctype="multipart/form-data" name="adminForm" id="game-form" class="form-validate">
	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', JText::_('COM_DRAUGHTS_TAB_GAME_GENERAL', true)); ?>
		<div class="row-fluid">
			<div class="span4 form-vertical">
				<fieldset class="adminform">
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('title'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('title'); ?></div>
					</div>
				</fieldset>
			</div>
			<div class="span4 form-vertical">
				<fieldset class="adminform">
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('category'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('category'); ?></div>
					</div>
				</fieldset>
			</div>
			<div class="span4 form-vertical">
				<fieldset class="adminform">
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('tag'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('tag'); ?></div>
					</div>
				</fieldset>
			</div>
		</div>
		<div class="row-fluid">
			<div class="span4 form-vertical">
				<fieldset class="adminform">
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('position'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('position'); ?></div>
					</div>
				</fieldset>
			</div>
			<div class="span4 form-vertical">
				<fieldset class="adminform">
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('movement'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('movement'); ?></div>
					</div>
				</fieldset>				
			</div>
			<div class="span4 form-vertical">
				Preview Window
				<div class="btn-toolbar">
					<input class="btn btn-small btn-primary" type="button" id="draughts_preview_refresh" value="Refresh" />
				</div>
				<p>Displays blank board, if position and movement are invalid.</p>
				<div class="draugths-responsive">
					<div class="draugths">
						<iframe id="draughts_preview_iframe" src="../components/com_draughts/draughts/draughts.php?position=&moves=" width="350" height="350" frameborder="0" scrolling="no" seamless="seamless">
							<p>Your browser does not support iframes.</p>
						</iframe>
					</div>
				</div>
				<script>
					function draughts_preview_reload(){
						document.getElementById('draughts_preview_iframe').src = '../components/com_draughts/draughts/draughts.php?position='+document.getElementById('jform_position').value+'&moves='+document.getElementById('jform_movement').value;
					}
					draughts_preview_refresh.onclick = draughts_preview_reload;
				</script>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'description', JText::_('COM_DRAUGHTS_TAB_GAME_DESCRIPTION', true)); ?>
		<div class="row-fluid">
			<div class="span6 form-horizontal">
				<fieldset class="adminform">
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('white_player_name'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('white_player_name'); ?></div>
					</div>
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('black_player_name'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('black_player_name'); ?></div>
					</div>
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('winner'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('winner'); ?></div>
					</div>
				</fieldset>
			</div>
			<div class="span6 form-horizontal">
				<fieldset class="adminform">
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('game_date'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('game_date'); ?></div>
					</div>
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('game_place'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('game_place'); ?></div>
					</div>
				</fieldset>
			</div>
		</div>
		<div class="row-fluid">
			<div class="span12 form-vertical">
				<fieldset class="adminform">
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('description'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('description'); ?></div>
					</div>
				</fieldset>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'publishing', JText::_('COM_DRAUGHTS_TAB_GAME_PUBLISHING_STATUS', true)); ?>
		<div class="row-fluid">
			<div class="span12 form-horizontal">
				<fieldset class="adminform">
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('state'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('state'); ?></div>
					</div>
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('created_by'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('created_by'); ?></div>
					</div>
				</fieldset>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>
	</div>
	<input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />
	<input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />
	<input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />
	<input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />
	<input type="hidden" name="task" value="" />
	<?php echo JHtml::_('form.token'); ?>
</form>
<div>&copy; 2015 <a href="http://jextbox.com" target="_blank">JExtBOX</a> by <a href="http://galaa.mn" target="_blank">Galaa</a></div>
