<?php

/**
 * @version     2.0.0
 * @package     com_draughts
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Galaa <contact@galaa.mn> - http://galaa.mn
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Draughts records.
 */
class DraughtsModelGames extends JModelList {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
	public function __construct($config = array()) {
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'ordering', 'a.ordering',
				'state', 'a.state',
				'title', 'a.title',
				'category', 'a.category',
				'tag', 'a.tag',
				'game_date', 'a.game_date',
				'game_place', 'a.game_place',
				'white_player_name', 'a.white_player_name',
				'black_player_name', 'a.black_player_name',
				'description', 'a.description',
			);
		}
		parent::__construct($config);
	}

    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     */
    protected function populateState($ordering = null, $direction = null) {
        // Initialise variables.
        $app = JFactory::getApplication('administrator');

        // Load the filter state.
        $search = $app->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        $published = $app->getUserStateFromRequest($this->context . '.filter.state', 'filter_published', '', 'string');
        $this->setState('filter.state', $published);

        
		//Filtering category
		$this->setState('filter.category', $app->getUserStateFromRequest($this->context.'.filter.category', 'filter_category', '', 'string'));


        // Load the parameters.
        $params = JComponentHelper::getParams('com_draughts');
        $this->setState('params', $params);

        // List state information.
        parent::populateState('a.title', 'asc');
    }

    /**
     * Method to get a store id based on model configuration state.
     *
     * This is necessary because the model is used by the component and
     * different modules that might need different sets of data or different
     * ordering requirements.
     *
     * @param	string		$id	A prefix for the store id.
     * @return	string		A store id.
     * @since	1.6
     */
    protected function getStoreId($id = '') {
        // Compile the store id.
        $id.= ':' . $this->getState('filter.search');
        $id.= ':' . $this->getState('filter.state');

        return parent::getStoreId($id);
    }

    /**
     * Build an SQL query to load the list data.
     *
     * @return	JDatabaseQuery
     * @since	1.6
     */
    protected function getListQuery() {
        // Create a new query object.
        $db = $this->getDbo();
        $query = $db->getQuery(true);

        // Select the required fields from the table.
        $query->select(
                $this->getState(
                        'list.select', 'DISTINCT a.*'
                )
        );
        $query->from('`#__draughts_games` AS a');
        
		// Join over the users for the checked out user
		$query->select("uc.name AS editor");
		$query->join("LEFT", "#__users AS uc ON uc.id=a.checked_out");
		// Join over the user field 'created_by'
		$query->select('created_by.name AS created_by');
		$query->join('LEFT', '#__users AS created_by ON created_by.id = a.created_by');
		// Join over the category 'category'
		$query->select('category.title AS category');
		$query->join('LEFT', '#__categories AS category ON category.id = a.category');

		// Filter by published state
		$published = $this->getState('filter.state');
		if (is_numeric($published)) {
			$query->where('a.state = ' . (int) $published);
		} else if ($published === '') {
			$query->where('(a.state IN (0, 1))');
		}

        // Filter by search in title
        $search = $this->getState('filter.search');
        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $query->where('a.id = ' . (int) substr($search, 3));
            } else {
                $search = $db->Quote('%' . $db->escape($search, true) . '%');
                $query->where('( a.title LIKE '.$search.'  OR  a.category LIKE '.$search.'  OR  a.tag LIKE '.$search.'  OR  a.game_date LIKE '.$search.'  OR  a.game_place LIKE '.$search.'  OR  a.white_player_name LIKE '.$search.'  OR  a.black_player_name LIKE '.$search.'  OR  a.description LIKE '.$search.' )');
            }
        }

		//Filtering category
		$filter_category = $this->state->get("filter.category");
		if ($filter_category) {
			$query->where("a.category = '".$db->escape($filter_category)."'");
		}

        // Add the list ordering clause.
        $orderCol = $this->state->get('list.ordering');
        $orderDirn = $this->state->get('list.direction');
        if ($orderCol && $orderDirn) {
            $query->order($db->escape($orderCol . ' ' . $orderDirn));
        }

        return $query;
    }

	public function getItems() {
		$items = parent::getItems();

		foreach ($items as $oneItem) {

			if ( isset($oneItem->tag) ) {
				// Catch the item tags (string with ',' coma glue)
				$tags = explode(",",$oneItem->tag);

				$db = JFactory::getDbo();
				$namedTags = array(); // Cleaning and initalization of named tags array

				// Get the tag names of each tag id
				foreach ($tags as $tag) {

					$query = $db->getQuery(true);
					$query->select("title");
					$query->from('`#__tags`');
					$query->where( "id=" . intval($tag) );

					$db->setQuery($query);
					$row = $db->loadObjectList();

					// Read the row and get the tag name (title)
					if (!is_null($row)) {
						foreach ($row as $value) {
							if ( $value && isset($value->title) ) {
								$namedTags[] = trim($value->title);
							}
						}
					}

				}

				// Finally replace the data object with proper information
				$oneItem->tag = !empty($namedTags) ? implode(', ',$namedTags) : $oneItem->tag;
			}
			if($oneItem->game_date === '0000-00-00'):
				$oneItem->game_date = '';
			endif;
		}
        return $items;
	}

}
