<?php

/**
 * @version     2.0.0
 * @package     com_draughts
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Galaa <contact@galaa.mn> - http://galaa.mn
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modelitem');
jimport('joomla.event.dispatcher');

/**
 * Draughts model.
 */
class DraughtsModelGame extends JModelItem {

    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @since	1.6
     */
    protected function populateState() {
        $app = JFactory::getApplication('com_draughts');

        // Load state from the request userState on edit or from the passed variable on default
        if (JFactory::getApplication()->input->get('layout') == 'edit') {
            $id = JFactory::getApplication()->getUserState('com_draughts.edit.game.id');
        } else {
            $id = JFactory::getApplication()->input->get('id');
            JFactory::getApplication()->setUserState('com_draughts.edit.game.id', $id);
        }
        $this->setState('game.id', $id);

        // Load the parameters.
        $params = $app->getParams();
        $params_array = $params->toArray();
        if (isset($params_array['item_id'])) {
            $this->setState('game.id', $params_array['item_id']);
        }
        $this->setState('params', $params);
    }

    /**
     * Method to get an ojbect.
     *
     * @param	integer	The id of the object to get.
     *
     * @return	mixed	Object on success, false on failure.
     */
	public function &getData($id = null) {

		if ($this->_item === null) {
			$this->_item = false;

			if (empty($id)) {
				$id = $this->getState('game.id');
			}

			// Get a level row instance.
			$table = $this->getTable();

			// Attempt to load the row.
			if ($table->load($id)) {
				// Check published state.
				if ($published = $this->getState('filter.published')) {
					if ($table->state != $published) {
						return $this->_item;
					}
				}

				// Convert the JTable to a clean JObject.
				$properties = $table->getProperties(1);
				$this->_item = JArrayHelper::toObject($properties, 'JObject');
			} elseif ($error = $table->getError()) {
				$this->setError($error);
			}
		}

		if ( isset($this->_item->created_by) ) {
			$this->_item->created_by_name = JFactory::getUser($this->_item->created_by)->name;
		}

		if ( isset($this->_item->tag) ) {
			// Catch the item tags (string with ',' coma glue)
			$tags = explode(",",$this->_item->tag);

			$db = JFactory::getDbo();
			$namedTags = array(); // Cleaning and initalization of named tags array

			// Get the tag names of each tag id
			foreach ($tags as $tag) {

				$query = $db->getQuery(true);
				$query->select("title");
				$query->from('`#__tags`');
				$query->where( "id=" . intval($tag) );

				$db->setQuery($query);
				$row = $db->loadObjectList();

				// Read the row and get the tag name (title)
				if (!is_null($row)) {
					foreach ($row as $value) {
						if ( $value && isset($value->title) ) {
							$namedTags[] = trim($value->title);
						}
					}
				}

			}

			// Finally replace the data object with proper information
			if (!empty($namedTags)) {
				$this->_item->tag = implode(', ',$namedTags);
			} else {
				$this->_item->tag = !empty($this->_item->my_tags) ? ($this->_item->my_tags) : ("");
			}
		}
		$this->_item->winner = JText::_('COM_DRAUGHTS_GAMES_WINNER_OPTION_' . $this->_item->winner);

		// Movement Speed
		$app = JFactory::getApplication();
		$params = $app->getParams();
		$this->_item->speed = $params->get('speed');

		// Access Control by User Group
		$user = JFactory::getUser();
		$user_groups = $user->getAuthorisedGroups();
		$allowed_groups = $params->get('user_group', array());
		settype($allowed_groups, 'array');
		if(!in_array(1, $allowed_groups)){ // Auto add Public
			array_push($allowed_groups, 1);
		}
		$this->_item->permission = (count(array_diff($user_groups, $allowed_groups)) === 0 || count($allowed_groups) === 1);

		// when Game date is empty
		if($this->_item->game_date === '0000-00-00'):
			$this->_item->game_date = '';
		endif;

		// position and moves formation
		$this->_item->position_f = str_ireplace(array(',', 'wp:', 'bp:', 'wk:', 'bk:'), array(', ', '&#9920; ', '&#9922; ', '&#9921; ', '&#9923; '), $this->_item->position);
		$this->_item->movement_f = str_replace(',', ', ', $this->_item->movement);

		return $this->_item;
    }

    public function getTable($type = 'Game', $prefix = 'DraughtsTable', $config = array()) {
        $this->addTablePath(JPATH_COMPONENT_ADMINISTRATOR . '/tables');
        return JTable::getInstance($type, $prefix, $config);
    }

    /**
     * Method to check in an item.
     *
     * @param	integer		The id of the row to check out.
     * @return	boolean		True on success, false on failure.
     * @since	1.6
     */
    public function checkin($id = null) {
        // Get the id.
        $id = (!empty($id)) ? $id : (int) $this->getState('game.id');

        if ($id) {

            // Initialise the table
            $table = $this->getTable();

            // Attempt to check the row in.
            if (method_exists($table, 'checkin')) {
                if (!$table->checkin($id)) {
                    $this->setError($table->getError());
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * Method to check out an item for editing.
     *
     * @param	integer		The id of the row to check out.
     * @return	boolean		True on success, false on failure.
     * @since	1.6
     */
    public function checkout($id = null) {
        // Get the user id.
        $id = (!empty($id)) ? $id : (int) $this->getState('game.id');

        if ($id) {

            // Initialise the table
            $table = $this->getTable();

            // Get the current user object.
            $user = JFactory::getUser();

            // Attempt to check the row out.
            if (method_exists($table, 'checkout')) {
                if (!$table->checkout($user->get('id'), $id)) {
                    $this->setError($table->getError());
                    return false;
                }
            }
        }

        return true;
    }

    public function getCategoryName($id) {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query
                ->select('title')
                ->from('#__categories')
                ->where('id = ' . $id);
        $db->setQuery($query);
        return $db->loadObject();
    }

    public function publish($id, $state) {
        $table = $this->getTable();
        $table->load($id);
        $table->state = $state;
        return $table->store();
    }

    public function delete($id) {
        $table = $this->getTable();
        return $table->delete($id);
    }

}
