<?php

/**
* @package     Content - JExtBOX Article Auto Manager
* @author      Galaa
* @publisher   JExtBOX.com - BOX of Joomla Extensions (www.jextbox.com)
* @copyright   Copyright (C) 2011-2023 Galaa
* @authorUrl   www.galaa.net
* @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
*/

// No direct access
defined('_JEXEC') or die('Restricted access');

class plgContentJExtBOXArticleAutoManager extends Joomla\CMS\Plugin\CMSPlugin
{

	private $current_article;

	function onContentPrepare ($context, &$article, &$params, $page = 0) {

		// Exit when view mode was not article
		if ($context != 'com_content.article') return;

		// Load all published and non checked out operations
		$operations = $this->_load_operations();

		// Exit when no published and non checked out operations were found
		if (!count($operations)) return;

		// To exclude the current article
		$this->current_article = $article->id;

		// Execute operations
		foreach ($operations as $num => $operation) {

			// Skip an operation if its execution time is not reached
			if(!$this->_is_execution_time_reached(
				$operation->execution_period, $operation->execution_month, $operation->execution_month_day, $operation->execution_week_day, $operation->execution_time, $operation->last_execute
			)) continue;

			// Execute
			if ($this->execute_operation($operation)) {
				// Save execution datetime
				$this->_save_execution_date($operation->id);
			}

		}

	}

	private function execute_operation ($operation) {

		// Prepare to access database
		$db = Joomla\CMS\Factory::getDbo();
		// Prepare conditions
		$operation->query_sql_prepared = $this->_prepare_condition($operation->query_sql, $operation->query_params);
		// Fields to update
		switch ($operation->operation) {
			case 1: // Change State
				$column = 'state';
				$value = $operation->new_state;
				break;
			case 2: // Modify the Featured Status
				$column = 'featured';
				$value = $operation->new_featured_status;
				break;
			case 3: // Move to Another Category
				$column = 'catid';
				$value = $operation->new_category;
				break;
			case 4: // Change Access Level
				$column = 'access';
				$value = $operation->new_access_level;
				break;
			case 5: // Extend Publish Down (for NOT NULL only)
				if (!in_array($operation->extend_interval, array(1,2,3,4,5,6,7,8)))
					return false;
				$column = 'publish_down';
				$value = 'DATE_ADD('.$db->quoteName($column).', INTERVAL '.$db->quote($operation->extend_number).' '.array(1 => 'YEAR', 2 => 'QUARTER', 3 => 'MONTH', 4 => 'WEEK', 5 => 'DAY', 6 => 'HOUR', 7 => 'MINUTE', 8 => 'SECOND')[$operation->extend_interval].')';
				break;
			default:
				return false;
		}
		$fields = array(
			$db->quoteName($column) . ' = ' . ($operation->operation == 5 ? $value : $db->quote($value))
		);
		// Conditions for which records should be updated
		$conditions = array(
			$db->quoteName('id') . ' != ' . $this->current_article,
			$operation->query_sql_prepared
		);
		// Query
		$query = $db->getQuery(true);
		$query->update($db->quoteName('#__content'))->set($fields)->where($conditions);
		$db->setQuery($query);
//echo '<pre>', $query->__toString(), '</pre>';
		// Execute query
		$result = $db->execute();
		// Update the table content_frontpage
		if ($operation->operation == 2 && $result) {
			$this->_update_table_content_frontpage();
		}
		// Return result
		return $result;

	}

	/*
	 *
	 * Additional functions
	 * 
	 */

	private function _prepare_condition ($sql, $params) {

		// switch > and <
		$sql = str_replace(array('> :age_', '< :age_'), array('%<% :age_', '%>% :age_'), $sql);
		$sql = str_replace(array('%<% :age_', '%>% :age_'), array('< :age_', '> :age_'), $sql);

		$db = Joomla\CMS\Factory::getDbo();
		$params = json_decode($params);
		foreach ($params as $key => $value) {
			if (strpos($key, 'age_created') !== false || strpos($key, 'age_publish_up') !== false) {
				$value = date('Y-m-d H:i:s', strtotime('-'.$value.' days'));
			}
			$sql = str_replace(':'.$key, $db->quote($value), $sql);
		}

		$sql = str_replace(
			array(
				'published_down = '.$db->quote(-1),
				'published_down = '.$db->quote(0),
				'published_down = '.$db->quote(1),
			),
			array(
				'published_down IS NULL',
				'published_down > '.($date = $db->quote(date('Y-m-d H:i:s'))),
				'published_down < '.$date,
			),
			$sql
		);

		$param_names = array('age_created', 'age_publish_up', 'hits', 'category', 'featured', 'access', 'state', 'published_down');
		$column_names = array('created', 'publish_up', 'hits', 'catid', 'featured', 'access', 'state', 'publish_down');
		foreach ($column_names as &$column_name) {
			$column_name = $db->quoteName($column_name);
		}
		$sql = str_replace($param_names, $column_names, $sql);
		$sql = '('.$sql.')';

		return $sql;

	}

	private function _load_operations () {

		$db = Joomla\CMS\Factory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select($db->quoteName(array(
					'id',
					'operation', 'new_state', 'new_featured_status', 'new_category', 'new_access_level', 'extend_interval', 'extend_number',
					'query', 'query_sql', 'query_params',
					'leave_articles', 'leave_count', 'leave_how',
					'execution_period', 'execution_month', 'execution_month_day', 'execution_week_day', 'execution_time', 'last_execute'
				)))
			->from($db->quoteName('#__jextboxarticleautomanager'))
			->where($db->quoteName('state').' = 1')
			->where('('.$db->quoteName('checked_out').' = '.$db->quote('0').' OR '.$db->quoteName('checked_out').' IS NULL)')
			->order($db->quoteName('ordering') . ' ASC')
		;
		$db->setQuery($query);
		return $db->loadObjectList();

	}

	private function _is_execution_time_reached ($execution_period, $execution_month, $execution_month_day, $execution_week_day, $execution_time, $last_execute) {

		if ($last_execute == '0000-00-00 00:00:00' || is_null($last_execute)) {
			return true;
		}

		$execution_time = str_pad($execution_time, 2, '0', STR_PAD_LEFT).':00:00';

		$last_execute_date = substr($last_execute, 0, 10);
		switch ($execution_period) {
			case 1: // daily
				$next_execute_date = date('Y-m-d', strtotime('+1 day', strtotime($last_execute_date)));
				break;
			case 2: // weekly
				$execution_week_day = str_replace(array(1,2,3,4,5,6,7), array('monday','tuesday','wednesday','thursday','friday','saturday','sunday'), $execution_week_day);
				$next_execute_date = date('Y-m-d', strtotime('next '.$execution_week_day, strtotime($last_execute_date)));
				break;
			case 3: // monthly
				$next_month = strtotime('next month', strtotime($last_execute_date));
				$year = date('Y', $next_month);
				$month = date('m', $next_month);
				$day = max(1, (int) $execution_month_day);
				while (!checkdate($month, $day, $year)) {
					$day--;
				}
				$next_execute_date = $year.'-'.$month.'-'.$day;
				break;
			case 4: // yearly
				$year = date('Y', strtotime('next year', strtotime($last_execute_date)));
				$month = $execution_month;
				$day = max(1, (int) $execution_month_day);
				while (!checkdate($month, $day, $year)) {
					$day--;
				}
				$next_execute_date = $year.'-'.$month.'-'.$day;
				break;
			default:
				return false;
				break;
		}
		$next_execute = strtotime($next_execute_date.' '.$execution_time);

		return time() > $next_execute;

	}

	private function _save_execution_date ($operation_id) {

		$db = Joomla\CMS\Factory::getDbo();
		$query = $db->getQuery(true);
		$query
			->update($db->quoteName('#__jextboxarticleautomanager'))
			->set($db->quoteName('last_execute') . '=' . $db->quote(date('Y-m-d H:i:s')))
			->where($db->quoteName('id') . '=' . $db->quote($operation_id))
		;
		$db->setQuery($query);
		$db->execute();

	}

	private function _update_table_content_frontpage () {

		$db = Joomla\CMS\Factory::getDbo();
		$sub_query = $db->getQuery(true);
		$sub_query
			->select($db->quoteName('id'))
			->from($db->quoteName('#__content'))
			->where($db->quoteName('featured').'='.$db->quote('0'))
		;
		$query = $db->getQuery(true);
		$query
			->delete($db->quoteName('#__content_frontpage'))
			->where($db->quoteName('content_id') . ' IN (' . $sub_query . ')')
		;
		$db->setQuery($query);
		$db->execute();

		$sub_sub_query = $db->getQuery(true);
		$sub_sub_query
			->select($db->quoteName('content_id'))
			->from($db->quoteName('#__content_frontpage'))
		;
		$sub_query = $db->getQuery(true);
		$sub_query
			->select($db->quoteName('id'))
			->from($db->quoteName('#__content'))
			->where($db->quoteName('featured').'='.$db->quote('1'))
			->where($db->quoteName('id') . ' NOT IN (' . $sub_sub_query . ')')
		;
		$query = $db->getQuery(true);
		$query
			->insert($db->quoteName('#__content_frontpage'))
			->columns($db->quoteName('content_id'))
			->values($sub_query)
		;
		$db->setQuery($query);
		return $db->execute();

	}

}

?>
