<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2023. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('JPATH_BASE') or die('Restricted access');

/**
 * Supports an HTML select list of categories
 */
class JFormFieldTimecreated extends Joomla\CMS\Form\FormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'timecreated';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput() {

		// Initialize variables.
		$html = array();

		$time_created = $this->value;
		if (!strtotime($time_created)) {
			$time_created = date('Y-m-d H:i:s');
			$html[] = '<input type="hidden" name="' . $this->name . '" value="' . $time_created . '" />';
		}
		$hidden = (boolean) $this->element['hidden'];
		if ($hidden == null || !$hidden) {
			$jdate = new Joomla\CMS\Date\Date($time_created);
			$pretty_date = $jdate->format(Joomla\CMS\Language\Text::_('DATE_FORMAT_LC2'));
			$html[] = '<div>' . $pretty_date . '</div>';
		}
		return implode($html);

	}

}

?>
