<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2023. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

class JextboxarticleautomanagerHelper
{

	/**
	 * Configure the Linkbar.
	 */
	public static function addSubmenu($vName = '')
	{

		if (version_compare(JVERSION, '4.0.0', '<')) {
			JHtmlSidebar::addEntry(
				JText::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_OPERATIONS'),
				'index.php?option=com_jextboxarticleautomanager&view=operations',
				$vName == 'operations'
			);
			JHtmlSidebar::addEntry(
				JText::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_ABOUT'),
				'index.php?option=com_jextboxarticleautomanager&view=about',
				$vName == 'about'
			);
		} else {
			Joomla\CMS\HTML\Helpers\Sidebar::addEntry(
				Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_OPERATIONS'),
				'index.php?option=com_jextboxarticleautomanager&view=operations',
				$vName == 'operations'
			);
			Joomla\CMS\HTML\Helpers\Sidebar::addEntry(
				Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_SIDEBAR_ABOUT'),
				'index.php?option=com_jextboxarticleautomanager&view=about',
				$vName == 'about'
			);
		}

	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return	JObject
	 * @since	1.6
	 */
	public static function getActions()
	{

		$user = version_compare(JVERSION, '5.0.0', '<') ? Joomla\CMS\Factory::getUser() : Joomla\CMS\Factory::getApplication()->getIdentity();
		$result	= new Joomla\CMS\Object\CMSObject;

		$assetName = 'com_jextboxarticleautomanager';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete', 'custom.execute.operation', 'custom.reset.last.executed'
		);

		foreach ($actions as $action) {
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;

	}

}

?>
