<?php

/**
 * @package     com_jextboxarticleautomanager
 * @copyright   Copyright (C) 2012-2023. All rights reserved.
 * @license     GNU/GPL License - https://www.gnu.org/licenses/gpl.html
 * @author      Galaa - www.galaa.net
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

class JextboxarticleautomanagerControllerOperations extends Joomla\CMS\MVC\Controller\AdminController
{
	/**
	 * Proxy for getModel.
	 * @since	1.6
	 */
	public function getModel($name = 'operation', $prefix = 'JextboxarticleautomanagerModel', $config = [])
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}

	/**
	 * Method to save the submitted ordering values for records via AJAX.
	 *
	 * @return  void
	 *
	 * @since   3.0
	 */
	public function saveOrderAjax()
	{

		$mainframe = Joomla\CMS\Factory::getApplication();

		// Get the input
		$input = $app->input;
		$pks = $input->post->get('cid', array(), 'array');
		$order = $input->post->get('order', array(), 'array');

		// Sanitize the input
		if (version_compare(JVERSION, '4.0.0', '<')) :
			JArrayHelper::toInteger($pks);
			JArrayHelper::toInteger($order);
		else :
			Joomla\Utilities\ArrayHelper::toInteger($pks);
			Joomla\Utilities\ArrayHelper::toInteger($order);
		endif;

		// Get the model
		$model = $this->getModel();

		// Save the ordering
		$return = $model->saveorder($pks, $order);

		if ($return)
		{
			echo '1';
		}

		// Close the application
		$mainframe->close();

	}

	// FREE VERSION

	public function execute_operation()
	{

		$mainframe = Joomla\CMS\Factory::getApplication();
		$mainframe->enqueueMessage(Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_MANUAL_EXECUTION_MSG_NOT_AVAILABLE'), 'warning');

		// Redirect to the list screen
		$mainframe->redirect(Joomla\CMS\Router\Route::_('index.php?option=com_jextboxarticleautomanager&view=operations', false));

	}

	// FREE VERSION

	public function reset_last_executed()
	{

		$mainframe = Joomla\CMS\Factory::getApplication();
		$mainframe->enqueueMessage(Joomla\CMS\Language\Text::_('COM_JEXTBOXARTICLEAUTOMANAGER_OPERATIONS_RESET_LAST_EXECUTED_MSG_NOT_AVAILABLE'), 'warning');

		// Redirect to the list screen
		$mainframe->redirect(Joomla\CMS\Router\Route::_('index.php?option=com_jextboxarticleautomanager&view=operations', false));

	}

}

?>
